// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#pragma once

class DrawQuads {
private:
	static LPDIRECT3DINDEXBUFFER9 mIndices;
	static DWORD mNIndices;
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices % 4 != 0); }
	static const bool isSurface = true;
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.quads; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_quads; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		DWORD nIndices = aPrimitiveCount*6;
		if(mNIndices < nIndices) {
			MYASSERT(nIndices < MAX_WORD);
			mNIndices = nIndices;
			GPHR(gp->m.pd3dDevice->CreateIndexBuffer(nIndices*2, D3DUSAGE_WRITEONLY,
				D3DFMT_INDEX16, D3DPOOL_DEFAULT, &mIndices, NULL));
			WORD* ptr;
			GPHR(mIndices->Lock(0, 0, (void**)&ptr, D3DLOCK_DISCARD));
			for(WORD i=0; i<aPrimitiveCount; i++) {
				ptr[i*6] = i*4;
				ptr[i*6 + 1] = i*4 + 1;
				ptr[i*6 + 2] = i*4 + 3;
				ptr[i*6 + 3] = i*4 + 1;
				ptr[i*6 + 4] = i*4 + 2;
				ptr[i*6 + 5] = i*4 + 3;
			}
			GPHR(mIndices->Unlock());
			GPHR(gp->m.pd3dDevice->SetIndices(mIndices));
		}
		GPHR(gp->m.pd3dDevice->DrawIndexedPrimitive(D3DPT_TRIANGLELIST, 0, 0,
			aPrimitiveCount * 4, 0, aPrimitiveCount * 2));
	}
	static WORD PrimitiveCount(WORD numvertices) { return numvertices / 4; }
};

class DrawTriangles {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices % 3 != 0); }
	static const bool isSurface = true;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices / 3; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.trislist; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_trilist; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_TRIANGLELIST, 0, aPrimitiveCount));
	}
};

class DrawTriangleStrip {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices < 3); }
	static const bool isSurface = true;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices - 2; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.trisstrip; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_tristrip; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_TRIANGLESTRIP, 0, aPrimitiveCount));
	}
};

class DrawTriangleFan {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices < 3); }
	static const bool isSurface = true;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices - 2; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.trisfan; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_trifan; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_TRIANGLEFAN, 0, aPrimitiveCount));
	}
};

class DrawLines {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices % 2 != 0); }
	static const bool isSurface = false;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices / 2; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.lineslist; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_linelist; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_LINELIST, 0, aPrimitiveCount));
	}
};

class DrawLineStrip {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD numvertices) { return (numvertices < 2); }
	static const bool isSurface = false;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices - 1; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.linesstrip; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_linestrip; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_LINESTRIP, 0, aPrimitiveCount));
	}
};

class DrawPoints {
public:
	static const char* const name;
	static bool VertexCountIsBad(WORD /*numvertices*/) { return false; }
	static const bool isSurface = false;
	static WORD PrimitiveCount(WORD numvertices) { return numvertices; }
	static __int64& StatPrimitives(GP::STATS& stat) { return stat.points; }
	static __int64& StatOps(GP::STATS& stat) { return stat.odraw_points; }
	static void __fastcall Draw(GP* gp, UINT aPrimitiveCount) {
		GPHR(gp->m.pd3dDevice->DrawPrimitive(D3DPT_POINTLIST, 0, aPrimitiveCount));
	}
};
